<?php
require_once '../../config/config.php';
require_once '../../config/auth.php';
require_once '../../config/database.php';
require_once '../../helpers/format_uang.php';

require_once '../../templates/header.php';
require_once '../../templates/sidebar.php';

// Pendapatan
$pendapatan_kasir = $db->query("
    SELECT SUM(total) AS total 
    FROM kasir_transaksi
")->fetch_assoc()['total'];

$pendapatan_jasa = $db->query("
    SELECT SUM(bunga) AS total 
    FROM pinjaman_angsuran
")->fetch_assoc()['total'];

$total_pendapatan = $pendapatan_kasir + $pendapatan_jasa;

// Beban / biaya
$biaya_operasional = $db->query("
    SELECT SUM(jumlah) AS total 
    FROM biaya_operasional
")->fetch_assoc()['total'];

$total_biaya = $biaya_operasional;

// Laba / Rugi
$laba_bersih = $total_pendapatan - $total_biaya;
?>

<h2>Laporan Laba Rugi</h2>

<table class="table">
    <tr>
        <th colspan="2">PENDAPATAN</th>
    </tr>
    <tr>
        <td>Penjualan (Kasir)</td>
        <td><?= format_uang($pendapatan_kasir); ?></td>
    </tr>
    <tr>
        <td>Jasa Pinjaman</td>
        <td><?= format_uang($pendapatan_jasa); ?></td>
    </tr>
    <tr>
        <th>Total Pendapatan</th>
        <th><?= format_uang($total_pendapatan); ?></th>
    </tr>

    <tr>
        <th colspan="2">BEBAN</th>
    </tr>
    <tr>
        <td>Biaya Operasional</td>
        <td><?= format_uang($total_biaya); ?></td>
    </tr>
    <tr>
        <th>Total Beban</th>
        <th><?= format_uang($total_biaya); ?></th>
    </tr>

    <tr>
        <th>LABA / RUGI BERSIH</th>
        <th><?= format_uang($laba_bersih); ?></th>
    </tr>
</table>

<?php require_once '../../templates/footer.php'; ?>
